/* Warning: this file is #included by both C and NASM code.
This file should contain only #define statements */

#ifndef __TL__SYS_H
#define	__TL__SYS_H

#ifdef __cplusplus
extern "C"
{
#endif

/* this must agree with the IDT layout in file STARTUP.ASM */
#define	SYSCALL_INT	0x30

/* file I/O */
#define	SYS_OPEN	0
#define	SYS_CLOSE	1
#define	SYS_WRITE	2
#define	SYS_READ	3
#define SYS_IOCTL	4	/* odds and ends */
#define SYS_SELECT	5	/* wait for file/device to change status */
#define	SYS_STAT	6	/* get length, perms, etc. of open file */
#define	SYS_SEEK	7
#define SYS_MMAP	8	/* memory-mapped files */
/* memory */
#define	SYS_SBRK	9	/* change size of data segment */
/* misc */
#define	SYS_TIME	10	/* get time-of-day */
/* tasks */
#define SYS_EXIT	11	/* task suicide */
#define	SYS_SLEEP	12	/* give up time slices for N microseconds */

#define	SYS_RUN		13	/* new program, new address space */
#define SYS_FORK	14	/* same program, new address space */
#define SYS_EXEC	15	/* new program, same address space */

#define SYS_WAIT	16	/* wait for other task to exit */
#define SYS_NICE	17	/* change priority of other task */
#define SYS_TASKINFO	18	/* get info about other task(s) */
/* signals */
#define	SYS_KILL	19


#ifdef __cplusplus
}
#endif

#endif
