#ifndef __TL_OS_H
#define	__TL_OS_H

#ifdef __cplusplus
extern "C"
{
#endif

/* max. number of tasks */
#define	MAX_TASK	16

/* max. number of virtual consoles */
#define	MAX_VC		12

/* max. number of sections in exec_t structure */
#define	MAX_SECT	5 /* code, data, BSS, heap, stack */

/* we will reprogram the 8253 timer chip to run at this rate */
#define	HZ	100

/* these must agree with the selector values
defined in the GDT near the end of file STARTUP.ASM */
#define	SYS_CODE_SEL	0x10
#define	SYS_DATA_SEL	0x18
#define	USER_CODE_SEL	0x23
#define	USER_DATA_SEL	0x2B
#define	LINEAR_DATA_SEL	0x30

/* task memory layout */
#define	USER_STACK_SIZE	4096
#define	KRNL_STACK_SIZE	4096
#define	USER_STACK_BASE	0xC0000000L
#define	INIT_HEAP_SIZE	0
#define	MAX_HEAP_SIZE	262144L /* 256K */

/* task->sect[0] is reserved for the user heap */
#define	HEAP_SECT	0
/* code, data, BSS, and stack go into these sections */
#define	FREE_SECT	(HEAP_SECT + 1)

#define	PAGE_SIZE	4096

/* And now, some magic. One entry in the page directory points to
the page directory itself. This lets us access page tables and the
page directory itself with virtual addresses. Chose one entry
(0-1023) to be used for this purpose: */
#define	PAGEDIR_SELF	1023L

/* ...you can then access the page tables at this virtual address: */
#define	PAGE_TABLES_VA	(PAGEDIR_SELF << 22)

/* ...and you can access the page directory itself at this virtual address: */
#define	PAGE_DIR_VA	((PAGEDIR_SELF << 22) | (PAGEDIR_SELF << 12))

/* routines to read little-endian data on little-endian CPU */
#define	read_le16(X)	(*(unsigned short *)(X))
#define	read_le32(X)	(*(unsigned long *)(X))

/* Initialization and other run-once code goes in ".dtext" section;
similar use-once data goes in ".ddata section." With paging, we can
release the memory used by these items after initialization.

Linux names the discardable code and data sections ".text.init"
and ".data.init". These names are too long (>8 chars) for DJGPP
COFF format.

Note that the extra ".dtext" and ".ddata" sections will appear
only in the object (.o) files. The kernel linker script combines
them into the regular ".text" and ".data" sections (but starts
them on page boundaries, so their memory can be freed). */
#if 0
#define	DISCARDABLE_CODE(X)				\
	X __attribute__((section (".dtext")));		\
	X

#define	DISCARDABLE_DATA(X)				\
	extern X __attribute__((section (".ddata")));	\
	X
/* no discardable code */
#else
#define	DISCARDABLE_CODE(X)	X

#define	DISCARDABLE_DATA(X)	X
#endif

#if defined(__TURBOC__)||!defined(__cplusplus)
typedef enum
{
	false = 0, true = 1
} bool;
#endif

/* the layout of this structure must match the order of registers
pushed and popped by the exception handlers in STARTUP.ASM */
typedef struct
{
/* pushed by pusha */
	unsigned edi, esi, ebp, esp, ebx, edx, ecx, eax;
/* pushed separately */
	unsigned ds, es, fs, gs;
	unsigned which_int, err_code;
/* pushed by exception. Exception may also push err_code.
user_esp and user_ss are pushed only if a privilege change occurs. */
	unsigned eip, cs, eflags, user_esp, user_ss;
} regs_t;

typedef struct
{
	unsigned adr;
	unsigned size;
	unsigned off;
/* section flags */
	unsigned read : 1;
	unsigned write : 1;
	unsigned exec : 1;
	unsigned load : 1;
	unsigned zero : 1;
} sect_t;

typedef struct _task
{
/* krnl_esp must be first */
	unsigned krnl_esp;
/* page_dir must be 2nd */
	unsigned *page_dir;
/* */
	unsigned init_krnl_esp, entry_pt;
	struct _console *vc;
	enum
	{
		TS_RUNNABLE = 1, TS_BLOCKED = 2, TS_ZOMBIE = 3
	} status;
	int exit_code, priority;
	unsigned timeout;
/* for linked lists of tasks (wait queues) */
	struct _task *next, *prev;
/* demand-loading! */
	unsigned num_sects;
	sect_t sect[MAX_SECT];
} task_t;

typedef struct
{
	task_t *head, *tail;
} wait_queue_t;

typedef struct	/* circular queue */
{
	unsigned char *data;
	unsigned size, in_base, in_ptr/*, out_base*/, out_ptr;
} queue_t;

typedef struct _console
{
/* virtual console input */
	queue_t keystrokes;
	unsigned saw_break_code : 1;
	unsigned unbuffered : 1;
/* virtual console output */
	unsigned esc, attrib;
	int csr_x, csr_y, esc1, esc2, esc3;
	unsigned short *fb_adr;
/* wait queue */
	wait_queue_t wait_queue;
} console_t;

#ifdef __cplusplus
}
#endif

#endif
