; vload.asm  Use VCPI interface to launch a pmode image
; Version 3.0, Dec 17, 1997
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________
;
; USE:
;   vload image.fil
;
;   The above command will read an image file of up to 64K bytes and then
; use VCPI requests to give control of the machine to that image.
;
;   I wrote VLOAD to simplify testing a practice pmode OS.  I edit/assemble/
; link the practice OS in DOS with an extended memory manager loaded.  Without
; VLOAD, I needed to reboot to get rid of the extended memory manager before
; each test of the practice OS.  With VLOAD, I can transfer control directly
; to the practice OS.  With or without VLOAD, I still need to reboot after
; running the practice OS.  There seemed so little chance of getting through
; a test without corrupting some part of memory, that I saw no reason to try
; to save enough context to return through VCPI.
;
;   On entry to the image:
;
;  The CPU is in protected mode with paging enabled.
;  The image file is loaded at linear address FF800000
;  The (sparse) set of all page tables is at linear address FFC00000
;  The page directory (which is also the last page table) is at linear
;  address FFFFF000
;  Page table 0 (at linear FFC00000) maps the first 4Mb as it was mapped
;  by the extended memory manager
;  Page table 1 (at linear FFC01000) is the prior page directory
;  Note that all of the above are double mappings of pages that still appear
;  in their original low addresses as well.
;
;  CS is a flat (4Gb minus 4Mb) segment, selector=8, base=0
;  EIP = FF800000 (first byte of the image file)
;  DS, ES are a flat 4Gb segment, selector=16, base=0
;_____________________________________________________________________________
;
; REBUILDING VLOC.COM
;
;   You will need the programs NASM and JLOC (I used nasm version 0.97 and
; JLOC version 0.5) and the following source files: vload.asm, gdt.inc,
; gdt_old.inc, gdt_new.inc, tss.inc, vload.lnk  
; 
;   Use the following commands:
;
; nasm -f obj vload.asm
; jloc vload.lnk vload.com
;_____________________________________________________________________________


	%include "gdt.inc"
	%include "tss.inc"

SEGMENT CODE USE16

	GLOBAL start
start:	mov	sp, stack_top		;Initialize stack
	mov	di, 0x80		;Command line
	mov	bl, [ds:di]		;Length of command line
	xor	bh, bh
.1:	inc	di
	mov	[bx+di], bh		;Null terminate command line
	cmp byte [di], ' '		;Discard trailing blanks
	je	.1

	mov	ax, 0x3D00		;Open the file
	mov	dx, di
	xor	cx, cx
	int	0x21
	jc near	fail

	mov	[handle], ax

	mov	ax, 0xDE00		;Check VCPI present
	int	0x67
	test	ah, ah
	jnz near fail

	xor	eax, eax
	mov	ax, cs			;Get segment
	shl	eax, 4			;Convert to linear address
	add	[GDT+2], eax		;Patch all the things that depend
	add	[IDTP+2], eax		;  on the load address
	add	[S2PMPTR], eax
	add	[S2PMTBL+4], eax
	add	[S2PMTBL+8], eax
	add	[S2PMTBL+16], eax
	add	[GDT+tss0_desc+2], eax	

	xor	edi, edi
	mov	di, stack_top+4095	;Size of our segment + 4095
	add	edi, eax		;Convert to linear address
	and	di, ~4095		;Round to page boundary
	mov	ebx, edi		;ebx = linear address
	sub	edi, eax		;edi = offset

	push	di			;Clear three pages
	xor	ax, ax
	cld
	mov	cx, (4096*3)/2
	rep stosw
	pop	di

; Set up three page tables:
;
;  di       ->   0'th page table
;  di+4096  ->   last page table == page directory
;  di+8192  ->   2'nd to last page table

	push	di			;Save 0'th page table pointer
	mov	bl, 7			;Make present and writable
	mov	[di+4096], ebx		;Temp 0'th page table
	mov	eax, cr3		;Old page directory
	mov	al, 7
	mov	[di+4096+4], eax	; is our second page table
	add	ebx, 4096		;New page directory
	add	di, 8192
	mov	[di-4], ebx		; is our last page table
	mov	eax, ebx
	mov	al, 0
	mov	[S2PMTBL], eax		;New CR3 value
	add	ebx, 4096
	mov	[di-8], ebx		;2'nd to last page table

	mov	cx, 16			;Map 16 pages (64Kb) of the buffer
.2:	add	ebx, 4096		; we will read the image to, into
	mov	[di], ebx		; the 2'nd to last page table,
	add	di, 4			; assuming linear==physical over
	loop	.2			; that range.

	mov	bx, [handle]		;Image file
	mov	eax, [di-64]		;Linear address of image buffer
	shr	eax, 4			;Paragraph

	mov	ds, ax			;Image buffer address
	xor	dx, dx
	mov	cx, -4			;Buffer size (maximum)
	mov	ah, 0x3F		;Read
	int	0x21
	mov	ah, 0x3E		;Close
	int	0x21

	push	cs			;Restore ds
	pop	ds
	pop	di			;Restore 0'th page table pointer

	mov	ax, 0xDE01		;Setup VCPI
	mov	si, vcpi_gdt		;VCPI section in our GDT
	int	0x67

	mov	ax, 0xDE0C		;Switch to protected mode
	mov	esi, [S2PMPTR]		;Linear address of table
	int	0x67

fail:	mov	ax, 0x4C00
	int	0x21

BITS 32

PG	EQU	4096			;Size of a page
AREA	EQU	(PG*1024)		;Area mapped by one page table
PGTABLE	EQU	(AREA*1023)		;Linear address of first page table
PGDIR	EQU	(PGTABLE+(PG*1023))	;Linear address of page directory
OLDDIR	EQU	(PGTABLE+PG)		;Linear address of old page directory

p_code:	cli
	mov	ax, flat_data
	mov	ds, eax
	mov	es, eax

	mov	eax, [OLDDIR]		;Old 0'th page table
	mov	[PGDIR], eax		;Overwrite our 0'th page table
	mov	eax, cr3		;Flush TLB
	mov	cr3, eax

	jmp dword flat_code:(AREA*1022)	;JMP to image

	alignb	4

S2PMPTR	dd	S2PMTBL
S2PMTBL	dd	0		;cr3
	dd	GDT		;Linear address of GDT descriptor
	dd	IDTP		;Linear address of IDT descriptor
	dw	0		;ldt selector
	dw	tss0_desc	;tss selector
	dd	p_code		;eip
	dw	flat_code	;cs

IDTP	dw	7FFh
	dd	0

handle	dw	0
	
	alignb	8

GDT	start_gdt

flat_code	desc	0, 0xFFBFF, D_CODE+D_READ+D_BIG+D_BIG_LIM

flat_data	desc	0, 0xFFFFF, D_DATA+D_WRITE+D_BIG+D_BIG_LIM

tss0_desc	desc	TSS0, tss_size-1, D_TSS

vcpi_gdt resd	6

	end_gdt

TSS0	resb	tss_size

	resb	8192			;Stack
stack_top:
