; idt.asm  Set up IDT
; Version 2.0, Jan 29, 1998
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	%include "gdt.inc"
	%include "idt.inc"

	GLOBAL	init_idt	;Initialize the IDT
	GLOBAL	idt		;The IDT itself

	extern	UNMAPPED_PAGE4IDT  ;The system definition must reserve a range
				   ;of 256 unmapped addresses for marking
				   ;unsupported interrupt vectors.
	extern	FLAT_CODE	   ;Code selector
	extern	UNMAPPED_VAL4IDT   ;bits 8-39 of the above 48 bit value

SEGMENT DATA USE32 align=16
SEGMENT DATA				;Workaround NASM problem with __SECT__

; Build an idt full of default values which will each cause unique looking
; page faults if triggered.  The descriptors for any entries that should be
; used are then overwritten at link time by JLOC's patch facility.
;_____________________________________________________________________________

idt:
	%assign vec 0
	%rep	0x80		;Half a maximum idt

	desc	UNMAPPED_PAGE4IDT+vec, FLAT_CODE, D_INT
	%assign vec vec+1
	%endrep
loadidt	dw	$-idt-1			;Length of idt
	dd	idt			;Linear address of idt

; One of the descriptors that must be overwritten is the one for the page
; fault.
;_____________________________________________________________________________

	patch_vec 0xE, page_fault, D_INT
	

SEGMENT INIT USE32

init_idt:
;
;Purpose:
;	Initialize the IDT
;Input:
;	none
;Output:
;	none
;Clobbers:
;	none
;_____________________________________________________________________________

        lidt    [loadidt]		;Load IDT
	ret				;Return

SEGMENT CODE USE32

page_fault:
;
;  Every page fault comes here.  Every unsupported interrupt goes to unmapped
;  memory and triggers a page fault.  First we figure out which happened,
;  then we dump the stack
;_____________________________________________________________________________

	cld

	cmp dword [esp+5], UNMAPPED_VAL4IDT	;Unsupported interrupt?
	jne	true_page_fault			;No
	mov	[esp+12], edi			;Yes: rearrange stack
	mov	[esp+8], esi
	xchg	[esp+4], ebp
	push	ebx
	push	edx
	push	ecx
	push	eax
	push	ds
	push	es
	and	ebp, 0FFh		;Number of unsupported interrupt
	push	ebp
	jmp	stack_dump		;JMP to stack dump

true_page_fault:

	pusha				;Save registers
	push	ds
	push	es
	push dword 0xE			;Interrupt number

stack_dump:
	push	ss		;Setup ds and es
	pop	ds
	push	ss
	pop	es
	mov	edi, 0xB8000	;Point at display
	mov	esi, reg_list	;List of register names
	mov	ebp, esp	;Point at stack contents
	mov	bl, 20		;Lines to display
.1:	mov	eax, ebp	;Display address
	call	hex8
	mov	eax, [ebp]	;Display contents
	call	hex8
	add	ebp, 4		;Next address
	mov	cl, [0x44A]	;Screen width
	sub	cl, 18		;Minus 18 characters used
	cmp byte [esi], al	;Past end of reg_list?
	jz	.3		;Yes
.2:	lodsb			;No: Display register name
	stosw
	test	al, al		;  null terminated
	loopnz	.2
.3:	rep stosw		;Clear to start of next line
	dec	bl		;Count lines
	jnz	.1

	jmp short $		;Hang
	
hex8:
;Purpose:
;	Converts value of eax in hex into display buffer pointed to by edi
;Inputs:
;	eax value
;	edi display pointer
;Outputs:
;	edi advanced
;	ecx zero
;	ax  0x700
;_____________________________________________________________________________

	mov	ecx, 8		;Count eight digits
.1:	rol	eax, 4		;Next digit
	push	eax		;Save
	and	al, 0xF		;Convert nibble to hex ascii
	cmp	al, 10
	sbb	al, 0x69
	das
	mov	ah, 7		;Default screen attribute
	stosw			;Store it and advance edi
	pop	eax		;Restore
	loop	.1		;Eight digits
	mov	ax, 0x700	;Invisible character, default attribute
	stosw			;Store it and advance edi
	ret			;Return

SEGMENT DATA
reg_list db	"Vector",0	;Names for items in the stack dump
	db	"es",0
	db	"ds",0
	db	"eax",0
	db	"ecx",0
	db	"edx",0
	db	"ebx",0
	db	" ",0		;Useless item
	db	"ebp",0
	db	"esi",0
	db	"edi",0
	db	"error   eip",0		;Two possibilities depending on
	db	"eip     cs",0		;whether there was an error code.  Let
	db	"cs      flags",0	;the user figure it out.
	db	"flags",0
	db	0		;Extra null terminates list
