; 8254.asm  
; Version 3.0, Jan 29, 1998
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________
;
;  This is the main module of an example in real time scheduling.
;  Please see the accompanying read.me file for detailed documentation.
;
;  This module contains both the code that is specific to the 8254 chip and
;  the code for the sample problem used for the demonstration.
;_____________________________________________________________________________

MY_EVENTS  EQU  26		;Total number of events for this test
fudge	   EQU  3		;Fudge factor
slow_down  EQU  7		;Slow display down by (1 << slow_down)
less_work  EQU	5

	%include "tmr.inc"	;8254 timer register definitions
	%include "gdt.inc"	;Descriptor definitions
	%include "8259.inc"	;8259 interrupt controller definitions
	%include "event.inc"	;Event data structure
	%include "idt.inc"	;define patch_vec

	global	_diag_events
	global	_diag_irets

; External routines:
	extern	init_8259	;Initialize the 8259
	extern	init_idt	;Initialize the IDT
	extern	idt		;The IDT itself
	extern	sift_heap	;Forward adjustment of one event in pri_heap
	extern	anti_sift_new	;Add one event to pri_heap
	extern	_Idle		;Idle loop

; External data
	extern	pri_heap	;Priority heap

SEGMENT STACK USE32 align=16
	resb	4096
stacktop:

SEGMENT BSS USE32 align=16
evt_tbl     resb (EVT_size*MY_EVENTS)	;Array of events

SEGMENT DATA USE32 align=4
time_counter dd	0			;Total elapsed time in microticks
_diag_events  dd 0			;Performance diagnostic
_diag_irets   dd 0			;Performance diagnostic

SEGMENT START USE32

start:	push	ds			;Switch to our own stack
	pop	ss
	mov	esp, stacktop

	call	init_idt		;Initialize standard modules
	call	init_8259

	mov	ebx, evt_tbl		;Build our set of events
	mov	ecx, MY_EVENTS		;Desired number of events
.10:	lea	eax, [ecx+'@']		;ID (and recurrence rate) of this event
	mov	[EVT_value+ebx], eax
	mov	[EVT_time+ebx], eax	;(and first execute time as well)
	mov dword [EVT_code+ebx], do_it	;Entry point for event
	mov dword [EVT_work+ebx], 0	;Working data used by event
	push	ecx			;anti_sift_new clobbers eax,ecx,edx,esi
	call	anti_sift_new		;Insert new event in priority heap
	pop	ecx
	add	ebx, EVT_size		;Next event
	loop	.10

	mov	al, TMR_SC0 + TMR_both + TMR_MD0  ;Set channel 0 to mode 0
	out	TMR_CTRL, al
	mov	al, TMR_SC1 + TMR_both + TMR_MD0  ;Set channel 1 to mode 0
	out	TMR_CTRL, al
	mov	al, 0				  ;Start channel 1 counting
	out	TMR_CNT1, al
	out	TMR_CNT1, al

	mov	al, 0xFE		;Disable all IRQ's except timer
	out	M_IMR, al

	mov	al, 9			;Start channel 0 counting
	out	TMR_CNT0, al
	mov	al, 0
	out	TMR_CNT0, al

	sti				;Enable interrupts

	jmp	_Idle			;Go to idle loop


SEGMENT CODE USE32
SEGMENT CODE				;Workaround NASM problem with __SECT__
patch_vec M_VEC, timer_service, D_INT	;Patch vector to point here
timer_service:
;
;  Get here on each timer interrupt
;_____________________________________________________________________________

	pusha				;Save registers
	push	ds
	push	es
	push	ss			;Set up ds (note ss is always valid)
	pop	ds
;You might want to set up es as well, if you write event routines that need it

	mov	esi, [pri_heap]		;Get next event
.10:	call dword [EVT_code+esi]	;Do it
	inc dword [_diag_events]	;Diagnostic
	call	sift_heap		;Update priority heap
	mov	esi, [pri_heap]		;Get next event
	mov	ebx, [time_counter]	;Get current time
	cmp	ebx, [EVT_time+esi]	;Is next event overdue?
	jns	.10			;Yes

	mov	al, TMR_READ - TMR_CNT + TMR_CH1   ;Read 8254 channel 1
	out	TMR_CTRL, al
	in	al, TMR_CNT1
	mov	dl, al
	in	al, TMR_CNT1
	mov	dh, al

; At this point in the code, ebx is an estimate of the time.  It might be
; accurate;  It might be low;  It can't be high.
; DX is the low 16 bits of the negative of the true time.  If (DX+BX) is
; zero then ebx was the correct time.

	add	edx, ebx		;Compute negative elapsed time
	neg	edx			;Elapsed time (16 bits)
	movzx	edx, dx			;32 bits
	add	ebx, edx		;Current time
	mov	[time_counter], ebx
	sub	ebx, [EVT_time+esi]	;Is next event overdue now?
	jns	.10			;Yes
	neg	ebx			;Time until next event due
; If the system has no regular high frequency events then we need to cover the
; special case of ebx>(65536+fudge) at this point.
	add	[time_counter], ebx	;preAdjust time
	sub	ebx, fudge		;Fudge factor because I/O's are slow
	jle	.10			;Do the event now.

	mov	al, bl			;Program 8254 for next event
	out	TMR_CNT0, al
	mov	al, bh
	out	TMR_CNT0, al

	mov	al, EOI			;Tell 8259 that interrupt is done
	out	M_PIC, al

	inc dword [_diag_irets]		;Diagnostic

	pop	es			;Restore registers
	pop	ds
	popa
	iret				;Exit interrupt

do_it:
;
;Purpose:
;	This single routine is used, in the example, as the event subroutine
;	for every event.
;
;Input:
;	esi points to event.
;Output:
;	none
;Clobbers:
;	The caller should assume this clobbers eax,ebx,ecx,edx,esi,edi,ebp
;	This version doesn't clobber all of those
;	
;_____________________________________________________________________________

	mov	eax, [EVT_value+esi]	;Which event is this
	imul	edx, eax, less_work	;Reschedule this much less than nominal
	add	[EVT_time+esi], edx	;Schedule next occurrence
	mov	ebx, [EVT_work+esi]	;Get internal counter
	inc dword [EVT_work+esi]	;Bump internal counter
	mov	ecx, [EVT_work+esi]	;Get bumbed internal counter
	shr	ebx, slow_down		;Waste all but 1 in (1<<slow_down) of
	shr	ecx, slow_down		;  the ocurrances of each event, in
	cmp	ecx, ebx		;  order to make the visible rate
	je	.20			;  reasonable.
	and	ebx, 2047		;Limit to first 2048 bytes of
	and	ecx, 2047		;  display memory.
	cmp	[0xB8000+2*ebx], al	;Is our letter still here?
	jnz	.10			;No: Another already overwrote it
	mov byte [0xB8000+2*ebx], ' '	;Yes: Erase it ourselves
.10:	mov	[0xB8000+2*ecx], al	;Display it in new location
.20:	ret				;Return
