; When started from bootf we get to this code with a temporary GDT,
; a temporary stack, temporary page tables, no TSS, no IDT and interrupts
; disabled.

; BOOTF sets up mapping so that the kernel starts at offset 0xFF800000
; In a real kernel we would have multiple modules so the linker must
; deal with the starting offset.  In a one module example we let NASM
; do the linking (NASM -f bin) so we must tell NASM the starting offset.

	ORG   0xFF800000

	BITS 32

SEGMENT .data
message db "Executing the ASM code",0

SEGMENT .text
start:
	mov	edi, 0xB8000
	mov	esi, message
	mov	ah, 7		;Text attribute
.again:	lodsb
	stosw
	test	al, al
	jnz	.again

	jmp short $		;Hang here
