/* use "native" output format of linker
OUTPUT_FORMAT("coff-go32") */
/* no leading underscores for symbols handled in asm: */
ENTRY(entry)
SECTIONS
{
/* 0x100 is ORG for .COM file
We will convert from COFF/ELF to binary after linking. */
    .text 0x100 :
    {
/* kernel code */
	g_code = .; _g_code = .;
	*(.text*)
	. = ALIGN(16);
    }
    .data :
    {
/* kernel data */
	g_data = .; _g_data = .;
	*(.data*)
	. = ALIGN(16);
    }
    .bss :
    {
/* kernel BSS */
	g_bss = .; _g_bss = .;
	*(.bss*)
	*(COMMON)
	. = ALIGN(16);
    }
/* end of kernel */
    g_end = .; _g_end = .;
}
