/*----------------------------------------------------------------------------
DEBUG ROUTINES

EXPORTS:
void dump(void *data_p, unsigned count);
void dump_iopb(void);
void dump_uregs(uregs_t *regs);
----------------------------------------------------------------------------*/
#include "defs.h"

/* IMPORTS
from KRNL.C */
void kprintf(const char *fmt, ...);

/* from START.ASM */
extern unsigned char g_tss_iopb[];
/*****************************************************************************
*****************************************************************************/
#define BPERL		16	/* byte/line for dump */

void dump(void *data_p, unsigned count)
{
	unsigned char *data = (unsigned char *)data_p;
	unsigned byte1, byte2;

	while(count != 0)
	{
		for(byte1 = 0; byte1 < BPERL; byte1++)
		{
			if(count == 0)
				break;
			kprintf("%02X ", data[byte1]);
			count--;
		}
		kprintf("\t");
		for(byte2 = 0; byte2 < byte1; byte2++)
		{
			if(data[byte2] < ' ')
				kprintf(".");
			else
				kprintf("%c", data[byte2]);
		}
		kprintf("\n");
		data += BPERL;
	}
}
/*****************************************************************************
*****************************************************************************/
void dump_iopb(void)
{
	unsigned i, offset, mask;

/* dump IOPB only if it was initially all-ones */
	if(g_tss_iopb[127] != 0xFF)
		return;
	kprintf("The following I/O ports were accessed:\n");
	for(i = 0; i < 1024; i++)
	{
		offset = i >> 3;
		mask = 0x01 << (i & 7);
		if((g_tss_iopb[offset] & mask) == 0)
			kprintf("%03X ", i);
	}
	kprintf("\n");
}
/*****************************************************************************
*****************************************************************************/
void dump_uregs(uregs_t *regs)
{
	kprintf("EDI=%08X    ESI=%08X    EBP=%08X    ESP=%08X    EBX=%08X\n",
		regs->edi, regs->esi, regs->ebp, regs->esp, regs->ebx);
	kprintf("EDX=%08X    ECX=%08X    EAX=%08X     DS=%08X     ES=%08X\n",
		regs->edx, regs->ecx, regs->eax, regs->ds, regs->es);
	kprintf(" FS=%08X     GS=%08X intnum=%08X  error=%08X    EIP=%08X\n",
		regs->fs, regs->gs, regs->which_int, regs->err_code,
		regs->eip);
	kprintf(" CS=%08X EFLAGS=%08X", regs->cs, regs->eflags);
//	if((regs->eflags & 0x20000uL) || (regs->cs & 0x03))
		kprintf("   uESP=%08X    uSS=%08X",
			regs->user_esp, regs->user_ss);
	kprintf("\n");
//	if(regs->eflags & 0x20000uL)
		kprintf("vES=%04X    vDS=%04X    vFS=%04X    vGS=%04X\n",
		regs->v_es & 0xFFFF, regs->v_ds & 0xFFFF,
		regs->v_fs & 0xFFFF, regs->v_gs & 0xFFFF);
}
