/*****************************************************************************
interrupt handler demo

CPU mode:	real mode (16-bit)
using DOS?	NO
language:	Borland C or Turbo C 3.x (works with 2.xx)

Note: if you use 'interrupt' and make a .COM file, you get TLINK error:
"Cannot generate COM file : segment-relocatable items present"

Modified 4/02/02 By Martin Coleman (martin@moedos.net) for Chris Giese (OS4D)
- This will be submitted to the Operating System Development tutorial site.
* Compiled with Turbo C 2.01 would you believe? ;-)
* Got working with external .obj file compiled with NASM. I left this a little
too long, people should really email me to remind me that I volunteered code
for them :)
*****************************************************************************/
#include <conio.h> /* getch(), cputs(), outportb() */
/* don't #include <dos.h>
it's declarations of getvect() and setvect() conflict with our own */

extern void interrupt(far *getvect(unsigned num));
extern void setvect(unsigned num, void interrupt (*h)());

char peekb(unsigned segment, unsigned offset);
void pokeb(unsigned segment, unsigned offset, char value);

#define	TIMER_VECT	8
#define	SYSCALL_VECT	50
#define	SYS_CPUTS	0

/*****************************************************************************
increment char in upper left corner of screen on every timer tick
*****************************************************************************/
static void interrupt timer_int(void)
{
	pokeb(0xB800, 0, peekb(0xB800, 0) + 1);
	outportb(0x20, 0x20);
}
/*****************************************************************************
*****************************************************************************/
#pragma argsused
static void interrupt syscall_int(int junk, int di, int si, int ds,
		int es, int dx, int cx, int bx, int ax)
{
	unsigned char syscall_num;

	syscall_num = ax;
	syscall_num >>= 8;
	switch(syscall_num)
	{
		case SYS_CPUTS:
			cputs((char *)si);
			break;
	}
}
/*****************************************************************************
*****************************************************************************/
int main(void)
{
	static const char *msg = "press a key to quit\n\r";
/**/
	void interrupt (*old_timer_vector)(void);
	void interrupt (*old_syscall_vector)(void);

/* save old vectors */
	old_timer_vector = getvect(TIMER_VECT);
	old_syscall_vector = getvect(SYSCALL_VECT);
/* install new handlers */
	setvect(TIMER_VECT, timer_int);
	setvect(SYSCALL_VECT, syscall_int);
/* make a system call */
	_AH = SYS_CPUTS;
	_SI = (unsigned)msg;
	asm int SYSCALL_VECT;
/* await key pressed */
	getch();
/* restore old vectors */
	setvect(TIMER_VECT, old_timer_vector);
	setvect(SYSCALL_VECT, old_syscall_vector);

	return 0;
}

